package com.javaeasily.demos;

public class App {
    public static void main(String[] args) {
        System.out.println("Loan Calculator".toUpperCase());
        System.out.println();

        int amount = 100;
        int years = 5;
        double interestRate = 10;

        if (amount > 0 && years > 0 && interestRate > 0.0) {
            printInputs(amount, years, interestRate);

            LoanCalculator calculator = new LoanCalculator(amount, years, interestRate);
            double repaymentAmount = calculator.calculateRepaymentAmount(amount, years, interestRate);

            printResult(repaymentAmount);
        } else {
            System.out.println("Invalid values - cannot calculate repayment amount.");
        }
    }

    private static void printInputs(int amount, int years, double interestRate) {
        System.out.println("Calculating loan based on:");
        System.out.println("Principal:       " + amount);
        System.out.println("Loan Term:       " + years + " year" + ((years > 0) ? "s" : ""));
        System.out.println("Interest Rate:   " + interestRate + "%");
    }

    private static void printResult(double currentAmountPayable) {
        String totalAmountDue = Double.toString(currentAmountPayable);
        int indexOfDecimalPoint = totalAmountDue.indexOf(".");
        String totalAmountDueFormatted = totalAmountDue.substring(0, indexOfDecimalPoint+3);
        System.out.println("Total Amount Due: " + totalAmountDueFormatted);
    }

}
