package com.javaeasily.demos;

public class LoanCalculator {
    private int amount = 100;
    private int years = 5;
    private double interestRate = 10;

    public LoanCalculator(int amount, int years, double interestRate) {
        this.amount = amount;
        this.years = years;
        this.interestRate = interestRate;
    }

    public double calculateRepaymentAmount(int amount, int years, double interestRate) {
        double interestRateMultiplier = 1 + interestRate / 100;

        double currentAmountPayable = amount;
        int currentYear = 1;
        while (currentYear <= years) {
            currentAmountPayable = currentAmountPayable * interestRateMultiplier;
            currentYear++;
        }
        return currentAmountPayable;
    }

    public int getAmount() {
        return amount;
    }

    public int getYears() {
        return years;
    }

    public double getInterestRate() {
        return interestRate;
    }
}
