package com.javaeasily.demos;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class App {
    public static void main(String[] args) {
        System.out.println("Loan Calculator Application".toUpperCase());
        System.out.println();

        int amount = 100;
        int years = 5;
        double interestRate = 10;

        try {
            printInputs(amount, years, interestRate);
            printResult(new LoanCalculator(amount, years, interestRate).calculateRepaymentAmount());
        } catch (LoanCalculationException e) {
            System.out.println(e.getMessage());
        }
    }

    private static void printInputs(int amount, int years, double interestRate) {
        System.out.println("Calculating loan based on:");
        System.out.println("Principal:       " + amount);
        System.out.println("Loan Term:       " + years + " year" + ((years > 0) ? "s" : ""));
        System.out.println("Interest Rate:   " + interestRate + "%");
    }

    private static void printResult(double currentAmountPayable) {
        NumberFormat formatter = new DecimalFormat("#0.00");
        System.out.println("Total Amount Due: " + formatter.format(currentAmountPayable));
    }

}
